import React, { useEffect , useState  } from 'react'
import {useRouter} from 'next/router';
import Layout from "~/components/layout";
import {Box} from './styled';
import ImagePreview from './components/picture-preview';
import { Button , Image as AImage , Divider } from 'antd';
import Image from 'next/image';
import errImg from "~/assets/errImg";
import api,{GetWebDeviceDetailResult} from './api';

export default function EquipmentLeasingDetail() {
  const router = useRouter();

  const [id, setId] = useState<number | null>(null);
  
  const [detail,setDetail] = useState<GetWebDeviceDetailResult | null>()

  useEffect(()=>{
    setId(Number(router.query.id))
  },[router])

  useEffect(()=>{
    if (id) {
      api
        .listDetailDeviceInfo({
          id:id
        })
        .then((res) => {
          setDetail(res.result || null);
        });
    }
  },[id])

  return (
    <Layout>
      <Box>
        <div className='item'>
          <ImagePreview imgList={detail?.wareImgs!}/>
          <div className='item-right'>
            <div className='title'>{detail?.wareTitle}</div>
              {
                detail?.tags?.length ? 
                (<div className='function'>
                {detail?.tags?.map(item=>(<div key={item} className='function-item'>{item}</div>))}
               </div>) : (<div className='function not'></div>)
              }
            <div className='menoy'>
              <span className='menoy-left'>¥{detail?.minRent}</span>
              <span className='menoy-right'>/天起</span>
            </div>
            <div className='classification'></div>
            <div className='botton-btn'>
                  <Button className='btn-left' size='small' type="primary">成为渠道商</Button>
                  <Button className='btn-right' size='small' type="primary">立即租赁</Button>
            </div>
          </div>
        </div>
        <div className='flow-path'>
              <Image className='image' src={require("./assets/flow-path.png")} alt="" />
        </div>
        <div className='prompt'>
          更多租金规则请前往【云享飞】微信小程序查
        </div>
        <Divider className='divider'>商品详情</Divider>
        {
          detail?.wareDetailContent ? <div style={{ textAlign: "center" }} dangerouslySetInnerHTML={{ __html: detail?.wareDetailContent}}>
          </div> : <div style={{ textAlign: "center" }} ></div>
        }
      </Box>
    </Layout>
  )
}
